<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Mtc\MercuryDataModels\Factories\VehicleSpecFactory;

class VehicleStandardEquipment extends Model
{
    use HasFactory;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'vehicle_standard_equipment';

    /**
     * @var string[]
     */
    protected $fillable = [
        'vehicle_id',
        'vehicle_type',
        'feature_id',
        'type',
        'description',
        'category',
        'price',
        'vat_amount',
        'code'
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    protected static function newFactory()
    {
        return VehicleSpecFactory::new();
    }

    public function vehicle(): BelongsTo
    {
        return $this->belongsTo(Vehicle::class, 'vehicle_id');
    }
}
