<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class BookingAvailabilityHoliday extends Model
{
    use HasFactory;

    protected $table = 'service_location_availability_holidays';

    protected $fillable = [
        'availability_id',
        'holiday_date',
        'note'
    ];

    public function availability(): BelongsTo
    {
        return $this->belongsTo(BookingAvailability::class, 'availability_id');
    }
}
