<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Relations\HasMany;
use Mtc\ContentManager\Contracts\ContentElement as ContentElementModel;

class ContentElement extends ContentElementModel
{
    /**
     * Mass assign attributes
     *
     * @var string[]
     */
    protected $fillable = [
        'title',
        'slug',
        'subtitle',
        'icon',
        'category',
        'is_enabled',
        'ui_component',
        'drag_and_drop',
        'preview_image',
        'data',
    ];

    /**
     * Name of the element category
     *
     * @return string
     */
    public function categoryName(): string
    {
        return collect(config('pages.block_categories', []))
            ->filter(fn (array $category) => $category['id'] === $this->category)
            ->first()['name'] ?? '';
    }

    public function newCarContent(): HasMany
    {
        return $this->hasMany(NewCarContent::class, 'element_id');
    }

    public function offerContent(): HasMany
    {
        return $this->hasMany(VehicleOfferContent::class, 'element_id');
    }
}
