<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class DealershipHoliday extends Model
{
    protected $table = 'dealership_holidays';

    protected $fillable = [
        'dealership_id',
        'date',
        'note',
    ];

    public function dealership(): BelongsTo
    {
        return $this->belongsTo(Dealership::class);
    }
}
