<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->string('tab', 100)->index();
            $table->string('section', 100)->index();
            $table->string('group')->index();
            $table->string('name');
            $table->string('config_key')->index();
            $table->string('type', 50);
            $table->string('value', 500)->nullable();
            $table->string('min_tier', 12)->nullable();
            $table->text('validation_rules')->nullable();
            $table->text('choices')->nullable();
            $table->text('description')->nullable();
            $table->unsignedInteger('order')->default(99);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('settings');
    }
}
