<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('vehicle_attribute_values', function (Blueprint $table) {
            $table->unique([
                'attribute_id',
                'owner_id',
                'owner_type',
                'index',
            ], 'vehicle_attribute_values_unique_columns');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('vehicle_attribute_values', function (Blueprint $table) {
            $table->dropColumn('vehicle_attribute_values_unique_columns');
        });
    }
};
