<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('catalog_offer_rules', function (Blueprint $table) {
            $table->id();
            $table->foreignId('catalog_offer_id')->index();
            $table->string('field');
            $table->string('condition', 30)->nullable();
            $table->string('value');
            $table->text('data')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('catalog_offer_rules');
    }
};
