<?php

namespace Mtc\MercuryDataModels;

use Mtc\MercuryDataModels\Factories\InvoiceHistoryFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Stancl\Tenancy\Database\Concerns\CentralConnection;

class InvoiceHistory extends Model
{
    use HasFactory;
    use CentralConnection;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'invoice_history';

    /**
     * Mass assign attributes
     *
     * @var string[]
     */
    protected $fillable = [
        'invoice_id',
        'type',
        'title',
        'details',
    ];

    /**
     * Cast attributes to types
     *
     * @var string[]
     */
    protected $casts = [
        'details' => 'array',
    ];

    /**
     * Model Factory
     *
     * @return InvoiceHistoryFactory
     */
    protected static function newFactory()
    {
        return InvoiceHistoryFactory::new();
    }

    /**
     * Relationship with invoice
     *
     * @return BelongsTo
     */
    public function invoice(): BelongsTo
    {
        return $this->belongsTo(Invoice::class);
    }
}
