<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasManyThrough;
use Illuminate\Database\Eloquent\Relations\HasOne;

class KeyloopLeaseOption extends Model
{
    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'keyloop_lease_options';

    /**
     * Mass assign attributes
     *
     * @var string[]
     */
    protected $fillable = [
        'was_recently_synced',
        'make_id',
        'model_id',
        'external_variant_id',
        'option_type',
        'option_code',
        'name',
        'default_vat_code',
    ];

    public function category(): BelongsTo
    {
        return $this->belongsTo(KeyloopLeaseOptionCategory::class, 'option_code', 'option_code');
    }

    public function price(): HasOne
    {
        return $this->hasOne(KeyloopLeaseOptionPrice::class, 'option_code', 'option_code');
    }

    public function getPrice(
        string $external_variant_id,
        KeyloopFleetKompactOptionType $option_type = KeyloopFleetKompactOptionType::FACTORY_OPTION
    ): ?KeyloopLeaseOptionPrice {
        $option_code = match ($option_type) {
            KeyloopFleetKompactOptionType::COLOUR => $this->colour_code ?? null,
            default => $this->option_code ?? null,
        };

        if (
            $option_type != KeyloopFleetKompactOptionType::COLOUR
            && $option_type != KeyloopFleetKompactOptionType::TRIM
        ) {
            return KeyloopLeaseOptionPrice::query()
                ->where('option_code', $this->option_code)
                ->where('external_variant_id', $external_variant_id)
                ->first();
        }

        return $this->pricesRelation()
            ->where('keyloop_lease_option_prices.external_variant_id', '=', $external_variant_id)
            ->where('keyloop_lease_option_price_mapping.external_variant_id', '=', $external_variant_id)
            ->where('keyloop_lease_option_price_mapping.option_code', '=', $option_code)
            ->first();
    }

    private function pricesRelation(): HasManyThrough
    {
        return $this->hasManyThrough(
            KeyloopLeaseOptionPrice::class,
            KeyloopLeasePriceMapping::class,
            'option_code',
            'option_code',
            'option_code',
            'price_option_code',
        );
    }
}
