<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Mtc\ContentManager\Traits\HasMedia;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Mtc\MercuryDataModels\Traits\EnsuresSlug;
use OwenIt\Auditing\Contracts\Auditable;

class PropertyAttributeValue extends Model implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    use HasFactory;
    use HasMedia;
    use EnsuresSlug;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'property_attribute_values';

    /**
     * Mass assign columns
     *
     * @var string[]
     */
    protected $fillable = [
        'property_id',
        'field_id',
        'slug',
        'type',
        'value',
        'value_float',
        'value_datetime',
        'value_text',
        'order',
        'index',
    ];

    protected $casts = [
        'active' => 'boolean',
        'data' => 'array',
    ];

    public static function getTypeColumn(string $type): string
    {
        return match ($type) {
            'image', 'editor' => 'value_text',
            'number' => 'value_float',
            'datetime' => 'value_datetime',
            default => 'value',
        };
    }

    public function property(): BelongsTo
    {
        return $this->belongsTo(Property::class, 'property_id');
    }

    public function propertyField(): BelongsTo
    {
        return $this->belongsTo(PropertyCategoryField::class, 'field_id');
    }

    public function getValue()
    {
        return match ($this->type) {
            'image' => json_decode($this->attributes['value_text']),
            'editor' => $this->attributes['value_text'],
            'number' => $this->attributes['value_float'],
            'datetime' => $this->attributes['value_datetime'],
            default => $this->attributes['value'],
        };
    }
}
