<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Mtc\MercuryDataModels\Factories\ValuationAdjustmentFactory;
use Mtc\VehicleValuation\Models\VehicleValuation;

class ValuationAdjustment extends Model
{
    use HasFactory;

    protected $table = 'valuation_adjustments';

    protected $fillable = [
        'is_active',
        'is_increase',
        'adjustment_amount',
        'adjustment_type',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'is_increase' => 'boolean',
    ];

    protected static function newFactory()
    {
        return ValuationAdjustmentFactory::new();
    }

    public function rules(): HasMany
    {
        return $this->hasMany(ValuationAdjustmentRule::class, 'adjustment_id');
    }


    public function scopeActive(Builder $query): void
    {
        $query->where('is_active', 1);
    }

    public function evaluate(VehicleValuation $valuation)
    {
        if (empty($this->rules->count())) {
            return false;
        }

        foreach ($this->rules as $rule) {
            if (!$this->operation($valuation->{$rule->column}, $rule->operator, $rule->value)) {
                return false;
            }
        }

        return true;
    }

    private function operation($value1, $operator, $value2)
    {
        switch ($operator) {
            case '=':
                return $value1 == $value2;
            case '!=':
                return $value1 != $value2;
            case '<=':
                return $value1 <= $value2;
            case '<':
                return $value1 < $value2;
            case '>':
                return $value1 > $value2;
            case '>=':
                return $value1 >= $value2;
        }
    }
}
