<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use OwenIt\Auditing\Contracts\Auditable;

class DealershipHoliday extends Model implements Auditable
{
    use \OwenIt\Auditing\Auditable;

    protected $table = 'dealership_holidays';

    protected $fillable = [
        'dealership_id',
        'date',
        'note',
    ];

    public function dealership(): BelongsTo
    {
        return $this->belongsTo(Dealership::class);
    }
}
