<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphOne;
use Illuminate\Support\Facades\Config;
use Mtc\MercuryDataModels\Factories\SeoDefaultFactory;

class SeoDefault extends Model
{
    use HasFactory;

    /**
     * Mass assign
     *
     * @var string[]
     */
    protected $fillable = [
        'section',
        'title',
        'description',
    ];

    /**
     * Hide from JSON
     *
     * @var string[]
     */
    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    /**
     * New model factory
     *
     * @return SeoDefaultFactory
     */
    protected static function newFactory()
    {
        return SeoDefaultFactory::new();
    }

    public function ogImage(): MorphOne
    {
        return $this->morphOne(Config::get('media.media_use_model'), 'owner');
    }
}
