<?php

namespace Mtc\MercuryDataModels\Traits;

use Illuminate\Support\Str;

trait EnsuresSlug
{
    private function ensureSlug()
    {
        if (empty($this->attributes['slug'])) {
            $slug = Str::slug($this->attributes['name']);
            $this->attributes['slug'] = $slug;

            $loop = 1;
            while (self::query()->where('slug', $this->slug)->exists()) {
                $this->attributes['slug'] = $slug . '-' . ($loop++);
            }
        }
    }
}
