<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('offer_types', function (Blueprint $table) {
            $table->id();
            $table->string('slug')->index();
            $table->string('name');
            $table->foreignId('template_id')->nullable()->index();
            $table->text('data')->nullable();
            $table->timestamps();
        });

        Schema::table('vehicle_offers', function (Blueprint $table) {
            $table->foreignId('type_id')->nullable()->index();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('offer_types');

        Schema::table('vehicle_offers', function (Blueprint $table) {
            $table->dropColumn('type_id');
        });
    }
};
