<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('search_index', function (Blueprint $table) {
            $table->id();
            $table->string('filter_type');
            $table->string('filter_id');
            $table->string('name')->nullable();
            $table->string('slug')->nullable()->index();
            $table->unsignedInteger('num_results')->nullable();
            $table->string('selection_hash', 500)->index()->nullable();
            $table->index(['filter_type', 'filter_id'], 'search_index_filter_object');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('search_index');
    }
};
