<?php

namespace Mtc\MercuryDataModels\Filters;

use App\Facades\Settings;
use Closure;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Config;
use Mtc\MercuryDataModels\VehicleOffer;

class OfferPriceMonthlyMinFilter extends PriceMonthlyMinFilter
{
    public function applyFilter($query, array $selection = [])
    {
        $query->whereHas('finance', function ($finance_query) use ($selection) {
            $finance_query->where('monthly_price', '>=', $selection);
        });
    }

    protected function getData(Closure $product_filtering, int $limit, array $selections = []): Collection
    {
        if (!self::$data->count()) {
            $offers = VehicleOffer::query()
                ->when(
                    Settings::get('filter-apply-selections-to-results'),
                    fn($query) => $query->where($product_filtering)
                )
                ->with('cheapestFinance')
                ->get();

            $min = floor($offers->min('cheapestFinance.monthly_price'));
            $max = floor($offers->max('cheapestFinance.monthly_price'));

            $ranges = collect(Config::get('automotive.filter-ranges.monthly_price'));
            self::$data = $ranges
                // Up to max range including one step over current max
                ->filter(fn($range, $i) => $range < $max || ($i > 0 && $range > $max && $ranges[$i - 1] < $max))
                ->filter(fn($range, $i) => $range > $min
                    || ($i < $ranges->count() - 1 && $range < $min && $ranges[$i + 1] > $min));
        }
        return self::$data;
    }
}
