<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Mtc\MercuryDataModels\Factories\TenantFeatureFactory;
use Stancl\Tenancy\Database\Concerns\BelongsToTenant;
use Stancl\Tenancy\Database\Concerns\CentralConnection;

/**
 * @property string $tenant_id
 * @property string $feature
 * @property array $data
 */
class TenantFeature extends Model
{
    use CentralConnection;
    use BelongsToTenant;
    use HasFactory;

    protected $fillable = [
        'feature',
        'tenant_id',
        'data',
    ];

    protected $casts = [
        'data' => 'array',
    ];

    protected static function newFactory(): TenantFeatureFactory
    {
        return TenantFeatureFactory::new();
    }
}
