<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Mtc\ContentManager\Traits\HasMedia;
use OwenIt\Auditing\Contracts\Auditable;

class VehicleTrim extends Model implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    use HasMedia;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'vehicle_trims';

    /**
     * Mass assign attributes
     *
     * @var string[]
     */
    protected $fillable = [
        'name',
        'new_car_id',
        'make_id',
        'model_id',
        'fuel_types',
        'colours',
        'description',
        'transmission_types',
        'mpg',
        'emissions',
        'engine_size',
        'battery_size',
        'range_miles',
        'battery_charge_time',
        'battery_quick_charge_time',
        'bhp',
        'ps',
        'active',
        'zero_to_sixty',
        'zero_to_sixty_two',
        'doors',
        'seats',
        'wheelbase',
        'cap_id',
        'full_price',
        'order',
        'data',
    ];

    protected $casts = [
        'fuel_types' => 'array',
        'colours' => 'array',
        'data' => 'array',
        'transmission_types' => 'array',
    ];

    public function newCar(): BelongsTo
    {
        return $this->belongsTo(NewCar::class, 'new_car_id');
    }

    /**
     * Relationship with model
     *
     * @return BelongsTo
     */
    public function make(): BelongsTo
    {
        return $this->belongsTo(VehicleMake::class, 'make_id');
    }

    public function model(): BelongsTo
    {
        return $this->belongsTo(VehicleModel::class, 'model_id');
    }
}
