<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('vehicle_offers', function (Blueprint $table) {
            $table->string('uuid')->index()->after('id')->nullable();
            $table->string('stock_provider', 50)->nullable()->index()->after('uuid');
            $table->string('vin')->after('stock_provider')->index()->nullable();
        });

        Schema::table('vehicle_standard_equipment', function (Blueprint $table) {
            $table->unique([
                'vehicle_id',
                'vehicle_type',
                'category',
                'description',
            ], 'vehicle_standard_equipment_unique_fields');
        });

        Schema::table('vehicle_tech_data', function (Blueprint $table) {
            $table->unique([
                'vehicle_id',
                'vehicle_type',
                'category',
                'description',
            ], 'vehicle_tech_data_unique_fields');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('vehicle_offers', function (Blueprint $table) {
            $table->dropColumn('uuid');
            $table->dropColumn('stock_provider');
            $table->dropColumn('vin');
        });

        Schema::table('vehicle_standard_equipment', function (Blueprint $table) {
            $table->dropUnique('vehicle_standard_equipment_unique_fields');
        });

        Schema::table('vehicle_tech_data', function (Blueprint $table) {
            $table->dropUnique('vehicle_tech_data_unique_fields');
        });
    }
};
