<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('vehicle_features', function (Blueprint $table) {
            $table->foreignId('vehicle_id')->after('id')->index();
        });
        Schema::table('vehicle_tech_data', function (Blueprint $table) {
            $table->foreignId('vehicle_id')->change();
            $table->string('code')->nullable()->change();
            $table->string('category')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('vehicle_features', function (Blueprint $table) {
            $table->dropColumn('vehicle_id');
        });
    }
};
