<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('colours', function (Blueprint $table) {
            $table->id();
            $table->string('colour', 32)->unique();
            $table->string('hex_code', 6)->nullable();
            $table->timestamps();
        });

        Schema::create('colour_mapping', function (Blueprint $table) {
            $table->id();
            $table->foreignId('colour_id');
            $table->string('sub_colour')->index();
            $table->unique(['colour_id', 'sub_colour'], 'colour_map_entry');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('colours');
        Schema::dropIfExists('colour_mapping');
    }
};
