<?php

namespace Mtc\MercuryDataModels\Filters;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;
use Mtc\MercuryDataModels\SearchIndex;

abstract class IndexedFilter extends IsFilter
{
    abstract public function filterType(): string;

    public function getIndexedResults(string $filter_type, int $limit, array $selections = []): Collection
    {
        return SearchIndex::query()
            ->where('filter_type', $filter_type)
            ->orderBy('filter_id')
            ->get();
    }
}
