<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;
use Mtc\MercuryDataModels\Factories\SeoRedirectFactory;

class SeoRedirect extends Model
{
    use HasFactory;

    protected $table = 'seo_redirects';

    /**
     * Mass assign
     *
     * @var string[]
     */
    protected $fillable = [
        'from',
        'to',
        'code',
        'from_domain',
        'to_domain',
        'has_regex',
    ];

    /**
     * Hide from JSON
     *
     * @var string[]
     */
    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    /**
     * New model factory
     *
     * @return SeoRedirectFactory
     */
    protected static function newFactory()
    {
        return SeoRedirectFactory::new();
    }

    public function toValue()
    {
        if (empty($this->to_domain)) {
            return $this->to;
        }

        return '//' . Str::replace(['https://', 'http://', '//'], '', rtrim($this->to_domain, '/'))
            . '/' . ltrim($this->to, '/');
    }
}
