<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('car_configurator_extras', function (Blueprint $table) {
            $table->text('description')->nullable()->change();
        });

        Schema::table('car_configurator_packages', function (Blueprint $table) {
            $table->text('description')->nullable()->change();
        });

        Schema::table('car_configurator_sections', function (Blueprint $table) {
            $table->string('label')->nullable();
        });

        Schema::table('car_configurator_wheels', function (Blueprint $table) {
            $table->text('short_description')->nullable();
            $table->text('description')->nullable()->change();
        });

        Schema::table('car_configurator_interiors', function (Blueprint $table) {
            $table->text('short_description')->nullable();
            $table->text('description')->nullable()->change();
        });

        Schema::table('car_configurator_editions', function (Blueprint $table) {
            $table->text('description')->nullable();
        });

        Schema::table('car_configurator_engines', function (Blueprint $table) {
            $table->text('description')->nullable();
        });
        Schema::table('car_configurator_colours', function (Blueprint $table) {
            $table->text('short_description')->nullable();
            $table->text('description')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('car_configurator_sections', function (Blueprint $table) {
            $table->dropColumn('label');
        });

        Schema::table('car_configurator_wheels', function (Blueprint $table) {
            $table->dropColumn('short_description');
        });

        Schema::table('car_configurator_interiors', function (Blueprint $table) {
            $table->dropColumn('short_description');
        });

        Schema::table('car_configurator_editions', function (Blueprint $table) {
            $table->dropColumn('description');
        });

        Schema::table('car_configurator_engines', function (Blueprint $table) {
            $table->dropColumn('description');
        });
        Schema::table('car_configurator_colours', function (Blueprint $table) {
            $table->dropColumn('short_description');
        });
    }
};
