<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVehicleOffersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('vehicle_offers', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('slug')->nullable()->index();
            $table->string('status')->nullable()->index();
            $table->boolean('featured')->index()->default(0);
            $table->string('derivative')->nullable();
            $table->foreignId('template_id')->nullable()->index();
            $table->foreignId('dealership_id')->nullable()->index();
            $table->foreignId('make_id')->nullable()->index();
            $table->foreignId('model_id')->nullable()->index();
            $table->foreignId('form_id')->nullable()->index();
            $table->decimal('price')->nullable();
            $table->decimal('deposit')->nullable();
            $table->dateTime('published_at')->nullable()->index();
            $table->text('seo')->nullable();
            $table->text('data')->nullable();
            $table->text('search_content')->nullable();
            $table->timestamps();
            $table->softDeletes();

            if (app()->runningUnitTests() === false) {
                $table->fullText('search_content');
            }
        });

        Schema::create('vehicle_offer_content', function (Blueprint $table) {
            $table->id();
            $table->foreignId('offer_id')->index();
            $table->foreignId('parent_id')->nullable()->index();
            $table->foreignId('global_content_id')->nullable()->index();
            $table->foreignId('element_id')->nullable()->index();
            $table->string('name')->nullable();
            $table->mediumText('content')->nullable();
            $table->text('search_content')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('vehicle_offers');
    }
}
