<?php

namespace Mtc\MercuryDataModels;

use App\ImportConditionRepository;
use App\Models\ImportCondition;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;
use OwenIt\Auditing\Contracts\Auditable;

class ShortcodeCondition extends Model implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    use SoftDeletes;

    protected $fillable = [
        'shortcode_id',
        'column',
        'operator',
        'value',
    ];

    protected $appends = [
        'field_name',
        'condition_name',
        'value_name',
    ];


    public function shortcode(): BelongsTo
    {
        return $this->belongsTo(Shortcode::class, 'shortcode_id');
    }

    public function getFieldNameAttribute(): string
    {
        return __('vehicles.' . $this->column);
    }

    public function getConditionNameAttribute(): string
    {
        return __('labels.conditions.' . $this->operator);
    }

    public function getValueNameAttribute()
    {
        return (new ImportConditionRepository())->getValue($this->column, $this->value);
    }
}
