<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('export_map_templates', function (Blueprint $table) {
            $table->id();
            $table->boolean('is_published')->default(false)->index();
            $table->string('sales_channel', 100)->nullable()->index();
            $table->string('title');
            $table->string('type')->default('vehicle')->index();
            $table->json('columns')->nullable();
            $table->json('headers')->nullable();
            $table->json('mapping_rules')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('export_map_templates');
    }
};
