<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bulk_import_log', function (Blueprint $table) {
            $table->id();
            $table->string('object_type')->index();
            $table->string('import_type')->nullable()->index();
            $table->foreignId('user_id')->nullable()->index();
            $table->text('automations')->nullable();
            $table->text('data')->nullable();
            $table->string('filename')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bulk_import_log');
    }
};
