<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('import_maps', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('slug')->index();
            $table->string('type')->index();
            $table->text('data')->nullable();
            $table->timestamps();
        });

        Schema::create('import_map_fields', function (Blueprint $table) {
            $table->id();
            $table->foreignId('map_id')->index();
            $table->string('on_file');
            $table->string('on_model')->nullable();
            $table->string('default_value')->nullable();
            $table->boolean('is_list')->default(0);
            $table->boolean('is_images')->default(0);
            $table->string('list_separator', 5)->nullable();
            $table->string('data')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('import_maps');
        Schema::dropIfExists('import_map_fields');
    }
};
