<?php

namespace Mtc\MercuryDataModels\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\MercuryDataModels\CarConfiguratorColour;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\Mtc\MercuryDataModels\ColourMap>
 */
class CarConfiguratorColourFactory extends Factory
{
    protected $model = CarConfiguratorColour::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'name' => $this->faker->word,
            'description' => $this->faker->paragraph(),
            'price' => random_int(1, 10000),
            'model_id' => random_int(1, 1000),
            'category' => $this->faker->word(),
            'hex' => $this->faker->hexColor(),
            'hex_gradient' => $this->faker->hexColor(),
        ];
    }
}
