<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('vehicle_features', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('slug')->index();
            $table->string('category')->nullable()->index();
            $table->text('conditions')->nullable();
            $table->timestamps();
        });

        Schema::table('vehicle_standard_equipment', function (Blueprint $table) {
            $table->foreignId('feature_id')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('vehicle_features');

        Schema::table('vehicle_standard_equipment', function (Blueprint $table) {
            $table->dropColumn('feature_id');
        });
    }
};
