<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Stancl\Tenancy\Database\Concerns\CentralConnection;

class ApiUsage extends Model
{
    use CentralConnection;

    protected $table = 'api_usage';

    protected $fillable = [
        'tenant_id',
        'endpoint',
        'method',
        'time_window',
        'hits',
        'avg',
        'min',
        'max',
    ];

    public function snapshots(): HasMany
    {
        return $this->hasMany(ApiUsageSnapshot::class, 'api_usage_id');
    }
}
