<?php

namespace Mtc\MercuryDataModels\Finance\Config;

use App\Facades\Settings;

class EvolutionConfig
{
    public const APR_CALCULATION = 3;
    public const DEALER_REPRESENTATIVE_APR_CALCULATION = 4;
    public const DEALER_TYPICAL_APR_CALCULATION = 5;

    public function enabled(): bool
    {
        return Settings::get('finance-evolution-enabled', false);
    }

    public function clientId(): string
    {
        return Settings::get('finance-evolution-client_id', '');
    }

    public function clientPassword(): string
    {
        return Settings::get('finance-evolution-client_password', '');
    }

    public function hpCalculationValue(): int
    {
        return Settings::get('finance-evolution-hp_calculation_value', 0);
    }

    public function pcpCalculationValue(): int
    {
        return Settings::get('finance-evolution-pcp_calculation_value', 0);
    }

    public function calculationType(): int
    {
        return Settings::get('finance-evolution-calculation_type') ?? self::APR_CALCULATION;
    }
}
