<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasManyThrough;

class KeyloopLeaseColour extends Model
{
    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'keyloop_lease_colours';

    /**
     * Mass assign attributes
     *
     * @var string[]
     */
    protected $fillable = [
        'make_id',
        'colour_code',
        'generic_colour_code',
        'name',
        'was_recently_synced',
        'hex_code',
        'gradient_hex_code',
    ];

    public function getPrice(string $external_variant_id): ?KeyloopLeaseOptionPrice
    {
        return $this->pricesRelation()
            ->where('keyloop_lease_option_prices.external_variant_id', '=', $external_variant_id)
            ->where('keyloop_lease_option_price_mapping.external_variant_id', '=', $external_variant_id)
            ->where('keyloop_lease_option_price_mapping.option_code', '=', $this->colour_code)
            ->first();
    }

    private function pricesRelation(): HasManyThrough
    {
        return $this->hasManyThrough(
            KeyloopLeaseOptionPrice::class,
            KeyloopLeasePriceMapping::class,
            'option_code',
            'option_code',
            'colour_code',
            'price_option_code',
        );
    }
}
