<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('labels', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('type')->nullable();
            $table->text('data')->nullable();
            $table->timestamps();
        });

        Schema::create('vehicle_labels', function (Blueprint $table) {
            $table->id();
            $table->foreignId('vehicle_id')->index();
            $table->foreignId('label_id')->index();
            $table->unsignedInteger('order')->default(0)->index();
            $table->timestamps();
        });

        Schema::create('vehicle_offer_labels', function (Blueprint $table) {
            $table->id();
            $table->foreignId('vehicle_offer_id')->index();
            $table->foreignId('label_id')->index();
            $table->unsignedInteger('order')->default(0)->index();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('labels');
        Schema::dropIfExists('vehicle_labels');
        Schema::dropIfExists('vehicle_offer_labels');
    }
};
