<?php

namespace Mtc\MercuryDataModels\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use Mtc\MercuryDataModels\KeyloopLeaseResidualValue;

class KeyloopLeaseResidualValueFactory extends Factory
{
    protected $model = KeyloopLeaseResidualValue::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'external_variant_id' => Str::random(),
            'contract_length' => random_int(1, 100),
            'annual_mileage' => random_int(1000, 1000),
            'residual_value_excluding_vat' => random_int(30000, 90000),
            'residual_value_including_vat' => random_int(30000, 90000),
        ];
    }
}
