<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('vehicle_offers', function (Blueprint $table) {
            $table->foreignId('franchise_id')->nullable()->index();
        });

        Schema::table('pages', function (Blueprint $table) {
            $table->foreignId('franchise_id')->nullable()->index();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('vehicle_offers', function (Blueprint $table) {
            $table->dropColumn('franchise_id');
        });

        Schema::table('pages', function (Blueprint $table) {
            $table->dropColumn('franchise_id');
        });
    }
};
