<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('page_content', function (Blueprint $table) {
            $table->boolean('hidden')->nullable()->index();
        });

        Schema::table('vehicle_offer_content', function (Blueprint $table) {
            $table->boolean('hidden')->nullable()->index();
        });

        Schema::table('new_car_content', function (Blueprint $table) {
            $table->boolean('hidden')->nullable()->index();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('page_content', function (Blueprint $table) {
            $table->dropColumn('hidden');
        });

        Schema::table('vehicle_offer_content', function (Blueprint $table) {
            $table->dropColumn('hidden');
        });

        Schema::table('new_car_content', function (Blueprint $table) {
            $table->dropColumn('hidden');
        });
    }
};
