<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('vehicle_packages', function (Blueprint $table) {
            $table->id();
            $table->string('name')->nullable()->index();
            $table->text('description')->nullable();
            $table->decimal('price')->nullable()->index();
            $table->decimal('vat_rate')->nullable()->comment('the VAT rate as decimal applicable to this package. 7% is 0.07');
            $table->string('vehicle_type')->nullable()->index()->comment('Vehicle type this package applies to e.g. stock vehicles, offers, lease vehicles');
            $table->text('conditions')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('vehicle_packages');
    }
};
