<?php

namespace Mtc\MercuryDataModels\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\MercuryDataModels\VehiclePackage;

class VehiclePackageFactory extends Factory
{
    protected $model = VehiclePackage::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'name' => $this->faker->word(),
            'price' => random_int(0, 100),
            'vat_rate' => (random_int(0, 100) / 100.00),
            'vehicle_type' => $this->faker->word(),
        ];
    }
}
