<?php

namespace Mtc\MercuryDataModels\Traits;

use App\Traits\AppliesQueryConditions;
use Illuminate\Support\Collection;
use Mtc\MercuryDataModels\KeyloopLeaseVehicleVariant;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehiclePackage;

trait HasVehiclePackages
{
    use AppliesQueryConditions;

    /**
     * Return packages applicable to the vehicle.
     *
     * @return array|\Illuminate\Support\Collection
     */
    public function getPackages(): Collection
    {
        $vehicle_type = match (get_class($this)) {
            Vehicle::class => 'vehicle',
            KeyloopLeaseVehicleVariant::class => 'lease-vehicle',
            default => null,
        };

        if (empty($vehicle_type)) {
            return [];
        }

        $packages = VehiclePackage::query()->where('vehicle_type', $vehicle_type)->get();

        // Find applicable packages by querying for the current vehicle using the package's conditions.
        // Applicable packages will include the current vehicle in their query results.
        return $packages->map(function ($package) {
            $query = $this->newQuery()->where('id', $this->id);
            $this->applyQueryConditions($query, $package->conditions);
            return $query->get()->count() ? $package : false;
        })->filter();
    }
}
