<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Mtc\MercuryDataModels\Factories\VehiclePackageFactory;

class VehiclePackage extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $table = 'vehicle_packages';

    protected $fillable = [
        'name',
        'description',
        'price',
        'vat_rate',
        'vehicle_type',
        'conditions',
    ];

    protected $casts = [
        'conditions' => 'array',
    ];

    protected static function newFactory()
    {
        return VehiclePackageFactory::new();
    }
}
