<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('api_usage', function (Blueprint $table) {
            $table->index('api_user_id', 'api_usage_user_id');
            $table->index('api_token_id', 'api_usage_token_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('api_usage', function (Blueprint $table) {
            $table->dropIndex('api_usage_user_id');
            $table->dropIndex('api_usage_token_id');
        });
    }
};
