<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Ensure that the term column exists.
        // This is required because term was added in a previous migration in a way that is not supported by mysqlite,
        // which is used to run unit tests.
        // We are ensuring that term exists during unit tests.
        if (!Schema::hasColumn('vehicle_offer_finance', 'term')) {
            Schema::table('vehicle_offer_finance', function (Blueprint $table) {
                $table->smallInteger('term')->nullable();
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('vehicle_offer_finance', 'term')) {
            Schema::table('vehicle_offer_finance', function (Blueprint $table) {
                $table->dropColumn('term');
            });
        }
    }
};
