<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Mtc\Crm\Traits\ModelSortAndFilter;
use Mtc\MercuryDataModels\Factories\FilterFeatureFactory;
use Mtc\MercuryDataModels\Traits\EnsuresSlug;

class FilterFeature extends Model
{
    use ModelSortAndFilter;
    use HasFactory;
    use EnsuresSlug;

    protected $table = 'filter_features';

    protected $fillable = [
        'name',
        'slug',
        'terms',
    ];

    protected $casts = [
        'terms' => 'array',
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    protected static function newFactory()
    {
        return FilterFeatureFactory::new();
    }

    protected static function boot()
    {
        parent::boot();
        self::creating(fn (self $entry) => $entry->ensureSlug());
    }

    public function vehicleFeatures(): HasMany
    {
        return $this->hasMany(VehicleStandardEquipment::class, 'feature_id');
    }
}
