<?php

namespace Mtc\MercuryDataModels\Filters;

use Closure;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;

class CheapestLeaseVariantFilter extends IsFilter
{
    public function applyFilter($query, array $selection = [])
    {
        $query->where('is_cheapest_variant', '=', true);
    }

    public function getResults(Closure $product_filtering, int $limit, array $selections = []): Collection
    {
        return collect();
    }

    public function getModel(): string
    {
        return $this->filter_target_model;
    }

    public function title(): string
    {
        return 'Cheapest Variant';
    }

    public function modelSlug(Model $model): string
    {
        return $model->name;
    }

    /**
     * Whether this
     * @return bool
     */
    public function visibleByDefault(): bool
    {
        return false;
    }
}
