<?php

namespace Mtc\MercuryDataModels\Filters;

use Closure;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;
use Mtc\MercuryDataModels\OfferType;

class OfferTypeFilter extends IsFilter
{
    public function applyFilter($query, array $selection = [])
    {
        $query->whereIn('type', $selection);
    }

    public function getResults(Closure $product_filtering, int $limit, array $selections = []): Collection
    {
        return OfferType::query()
            ->get();
    }

    /**
     * Format result for front-end
     *
     * @param Collection $collection
     * @return array
     */
    public function format(Collection $collection): array
    {
        return [
            'title' => $this->title(),
            'ui_component' => $this->uiComponentType(),
            'hide_in_ui' => $this->hideInUi(),
            'has_load_more' => $this->hasLoadMore($collection),
            'show' => $this->visibleByDefault(),
            'min_count_to_show' => $this->minCountToShow(),
            'results' => $this->formatResults($collection)
        ];
    }

    private function formatResults(Collection $collection): Collection
    {
        return $collection->map(fn($item) => [
            'id' => $item->id,
            'name' => $item->name,
            'count' => null,
            'slug' => $item->slug,
        ]);
    }


    public function getModel(): string
    {
        return OfferType::class;
    }

    public function title(): string
    {
        return 'Offer Type';
    }

    public function modelSlug(Model $model): string
    {
        return '';
    }
}
