<?php

namespace Mtc\MercuryDataModels;

use Carbon\Carbon;
use Illuminate\Support\Facades\Cache;
use Mtc\ContentManager\Models\MediaSize;
use Mtc\ContentManager\Models\MediaUse as MediaUseModel;

class MediaUse extends MediaUseModel
{
    protected static array $cached_sizes = [];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'media_id',
        'owner_type',
        'owner_id',
        'alt_text',
        'title',
        'description',
        'caption',
        'dimensions',
        'allowed_sizes',
        'data',
        'order',
        'primary',
        'secondary',
        'flags',
        'interior',
        'exterior',
        'damages',
    ];

    protected string $override_owner_type = '';

    public function getOwnerType(): string
    {
        if (!empty($this->override_owner_type)) {
            return $this->override_owner_type;
        }

        return match ($this->owner_type) {
            'new-car-content', 'new-car-version', 'offer-content', 'offer-version' => 'content',
            default => $this->owner_type,
        };
    }

    public function setOverrideOwnerType(string $override_owner_type)
    {
        $this->override_owner_type = $override_owner_type;
    }

    protected function cacheName(string $dimensions, string $ownerType): string
    {
        return tenant('id') . '-' . parent::cacheName($dimensions, $ownerType);
    }

    private function nameToDimensions(string $dimensions): ?array
    {
        if (array_key_exists($dimensions, \config('media.thumbnail_sizes'))) {
            list($width, $height) = explode('x', \config('media.thumbnail_sizes.' . $dimensions));
            return compact('width', 'height');
        }

        $ownerType = $this->getOwnerType();
        $cache_name = $this->cacheName($dimensions, $ownerType);
        if (!empty(self::$cached_sizes[$cache_name])) {
            return self::$cached_sizes[$cache_name];
        }

        $model_dimensions = Cache::remember(
            tenant('id') . '-media-sizes-' . $ownerType,
            Carbon::now()->addMinutes(5),
            fn() => MediaSize::query()
                ->where('model', $ownerType)
                ->get()
                ->keyBy('label')
                ->toArray()
        );

        foreach ($model_dimensions as $name => $value) {
            self::$cached_sizes[$this->cacheName($value['label'], $ownerType)] = $model_dimensions[$name] ?? [];
        }

        return self::$cached_sizes[$cache_name] ?? null;
    }
}
