<?php

namespace Mtc\MercuryDemoData;

use App\Jobs\ImportImagesFromUrlList;
use Illuminate\Database\Seeder;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Support\Facades\File;
use Mtc\ContentManager\Facades\Media;
use Mtc\MercuryDataModels\BodyStyleType;
use Mtc\MercuryDataModels\Dealership;
use Mtc\MercuryDataModels\DrivetrainType;
use Mtc\MercuryDataModels\FuelType;
use Mtc\MercuryDataModels\TransmissionType;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehicleMake;
use Mtc\MercuryDataModels\VehicleModel;

class DemoVehicleSeeder extends Seeder
{
    use DispatchesJobs;

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $this->dealership = Dealership::query()
            ->create([
                'name' => 'fuzzy panda motors',
                'email' => 'noreply@mtc.co.uk',
                'contact_no' => '1231231122',
                'address1' => 'Shed 26',
                'address2' => 'City Quay',
                'city' => 'Dundee',
                'postcode' => 'DD1 3JA',
                'country' => 'GB',
            ]);

        $media = Media::importImageFromUrl(dirname(__DIR__) . '/data/dealership.jpg');
        Media::setUsesForModel([$media->id], $this->dealership, ['primary' => true]);

        collect(json_decode(File::get(dirname(__DIR__) . '/data/demo-vehicles.json'), true))
            ->each(fn($vehicle) => $this->import($vehicle));
    }

    /**
     * Import a single vehicle
     *
     * @param $vehicle_data
     * @return void
     */
    private function import($vehicle_data)
    {
        $images = collect($vehicle_data['images'] ?? [])
            ->map(fn($image) => dirname(__DIR__) . '/data/vehicle-images/' . $image);
        $features = $vehicle_data['features'];
        unset($vehicle_data['images'], $vehicle_data['features']);

        $vehicle_data['is_published'] = true;
        $vehicle_data['dealership_id'] = $this->dealership->id;
        $vehicle_data['make_id'] = VehicleMake::query()->updateOrCreate([
            'name' => $vehicle_data['make_id']
        ])->id;
        $vehicle_data['model_id'] = VehicleModel::query()->updateOrCreate([
            'name' => $vehicle_data['model_id'],
            'make_id' => $vehicle_data['make_id'],
        ])->id;
        $vehicle_data['body_style_id'] = BodyStyleType::query()->updateOrCreate([
            'name' => $vehicle_data['body_style_id']
        ])->id;
        $vehicle_data['transmission_id'] = TransmissionType::query()->updateOrCreate([
            'name' => $vehicle_data['transmission_id']
        ])->id;
        $vehicle_data['fuel_type_id'] = FuelType::query()->updateOrCreate([
            'name' => $vehicle_data['fuel_type_id']
        ])->id;
        $vehicle_data['drivetrain_id'] = DrivetrainType::query()->updateOrCreate([
            'name' => $vehicle_data['drivetrain_id']
        ])->id;

        /** @var Vehicle $vehicle */
        $vehicle = Vehicle::query()->create($vehicle_data);
        collect($features)->each(fn($specData) => $vehicle->equipment()->create($specData));

        $this->dispatch(new ImportImagesFromUrlList($images, $vehicle));
    }
}
